## **Overview**

- Acts as a **cloud-based web proxy** enabling customers to filter, scan, and inspect HTTP/HTTPS web traffic.
- **DNS Protection** inspects partial web traffic with Intelligent Proxy, while SWG applies protection to all web destinations.
- Proxies **HTTP/HTTPS traffic** across both standard and non-standard web ports.

---

## **Key Features of SWG**

### **1. Visibility, Control, and Protection**

- Provides comprehensive security across all web traffic, including HTTPS.

### **2. Content Filtering**

- **Category-based filtering**: Blocks many URLs at once using Cisco Talos' database shared across Cisco security solutions.
- URL blocking and allowing to enforce acceptable use policies.

### **3. File Inspection and Malware Analytics**

- Utilizes **Cisco Secure Endpoint** for file scanning and **Cisco Secure Malware Analytics** for sandboxing.
- Retroactively alerts on files initially deemed safe but later identified as malicious.
- High-risk files undergo deeper analysis in the **sandbox**.

### **4. URL Logging and Reporting**

- Full URL logging for visibility and detailed reports, including:
    - URL addresses
    - Network identity
    - Allow/block actions
- **Cloud application discovery** for monitoring app usage and risk profiles.

### **5. File Type Control**

- Restricts download of specific file types (e.g., PDF, MP3).
- **Detection engine** identifies file types even if extensions are altered.

### **6. SSL Decryption**

- Decrypts encrypted traffic for enhanced visibility and granular controls.
- Required for:
    - Application controls
    - URL-level functionality
    - File scanning/sandboxing
- **Selective decryption** allows exclusions for specific categories, apps, or domains.

### **7. Application Visibility and Control**

- Monitors app usage and blocks specific applications or categories.
- Granular controls for SaaS applications:
    - Block actions (e.g., post/share on social media, attachment uploads to webmail).

---

## **Connection Methods**

### **1. Cisco Secure Client with Roaming Security Module**

- **Device-based solution** for Windows/Mac.
- Provides **on/off-network protection**.
- Routes DNS and web traffic to Umbrella for security and visibility.

### **2. IPsec Tunnel**

- Protects on-premises devices (e.g., servers, IoT).
- Manages DNS, web protection, and firewall policies via Umbrella dashboard.

### **3. Proxy Chaining & PAC File**

- **Proxy Chaining**: For organizations with an existing proxy server.
- **PAC File**: Directly forwards web traffic to Umbrella via browser configuration.
- Suitable for virtual desktop environments.

---

## **Web Policy in Umbrella**

- The core feature of Umbrella's **Secure Internet Gateway (SIG)**.
- Provides **URL-layer visibility, security, and enforcement**.

### **1. Configuring Web Policy**

- **Rulesets**: Define security, permission, and access controls for identities.
- **Rules**: Fine-tune actions (allow, warn, block, isolate) for destinations.

### **2. Ruleset Configuration**

- **Identities**: Assign specific groups or devices to rulesets.
- **Settings**:
    - **Block Page Customization**: Modify block page appearance.
    - **Tenant Controls**: Restrict SaaS app access (e.g., Microsoft 365, Dropbox).
    - **File Analysis**: Integrates AMP and Secure Malware Analytics for malware scanning.
    - **File Type Control**: Blocks downloads of specific file types.
    - **HTTPS Inspection**: Enables secure traffic decryption.
    - **SafeSearch**: Filters explicit content in search engines (Google, YouTube, Bing, Yahoo).
    - **SAML Authentication**: Supports identity authentication on networks/tunnels.
    - **Security Settings**: Blocks harmful destinations by category.

### **3. Rule Actions**

- **Allow – Security Enforced**: Allows destination access while enforcing security.
- **Warn**: Displays a warning page before access.
- **Block**: Denies access to destinations.
- **Isolate**: Redirects browsing to a cloud-based virtual browser for protection.

### **4. Destination Types for Rules**

- **Application Setting**: Controls access to specific apps.
- **Content Category**: Manages access to predefined website categories (e.g., gambling, social networking).
- **Destination List**: Allows/blocks specific destinations added to Umbrella.